<?php

namespace App\Http\Controllers;

use App\Attendance;
use Illuminate\Http\Request;
use App\BusinessLocation;


class AttendanceController extends Controller
{
    public function index(Request $request)
    {
        if (!auth()->user()->can('attendance.access')) {
            abort(403, 'Unauthorized action.');
        }
        $business_id = request()->session()->get('user.business_id');
        $business_locations = BusinessLocation::forDropdown($business_id);
        $query = Attendance::with('user', 'business', 'business_location')->whereIn('business_location_id', $business_locations->keys());
    
        if ($request->has('start_date') && $request->has('end_date')) {
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
    
            $query->whereBetween('created_at', [$startDate, $endDate]);
        }
    
        $attendances = $query->get();
    
        return view('attendance.index', compact('attendances'));
    }
    
}
