@extends('layouts.app')
@section('title', __('Attendances'))

@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>Attendance
        <small>List of Attendances</small>
    </h1>

    <form method="GET" action="{{ route('attendances.index') }}" class="form-inline">
        <div class="form-group mb-2">
            <label for="start_date" class="sr-only">Start Date</label>
            <input type="date" name="start_date" id="start_date" class="form-control" placeholder="Start Date" value="{{ request('start_date') }}">
        </div>
        <div class="form-group mx-sm-3 mb-2">
            <label for="end_date" class="sr-only">End Date</label>
            <input type="date" name="end_date" id="end_date" class="form-control" placeholder="End Date" value="{{ request('end_date') }}">
        </div>
        <button type="submit" class="btn btn-primary mb-2">Filter</button>
        <a href="{{ route('attendance.export', ['start_date' => request('start_date'), 'end_date' => request('end_date')]) }}" class="btn btn-success mb-2">Export to Excel</a>
    </form>
</section>

<!-- Main content -->
<section class="content">

    @component('components.widget', ['class' => 'box-primary', 'title' => __( 'Attendances' )])
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <table class="table table-bordered table-striped">
                          <thead>
    <tr>
        <th>Name</th>
        <th>Time In</th>
        <th>Time Out</th>
        <th>Date</th>
        <th>Business</th>
        <th>Business Location</th>
    </tr>
</thead>
<tbody>
    @foreach($attendances as $attendance)
        <tr>
            <td>{{ $attendance->user->user_full_name }}</td>
            <td>{{ $attendance->time_in ? $attendance->time_in->format('h:i A') : 'N/A' }}</td>
            <td>{{ $attendance->time_out ? $attendance->time_out->format('h:i A') : 'N/A' }}</td>
            <td>{{ $attendance->created_at ? $attendance->created_at->format('Y-m-d') : 'N/A' }}</td>
            <td>{{ $attendance->business ? $attendance->business->name : 'N/A' }}</td>
            <td>{{ $attendance->business_location ? $attendance->business_location->name : 'N/A' }}</td>
        </tr>
    @endforeach
</tbody>

                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endcomponent

  
</section>
@endsection