<!doctype html>
<html lang="{{ config('app.locale') }}">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- CSRF Token -->
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>@yield('title', 'Home Page')</title>

        <link rel="stylesheet" href="{{ asset('css/vendor.css') }}">

        <!-- Styles -->
        <style>
            body {
                min-height: 100vh;
                background-color: #243949;
                color: #fff;
                position: relative;
            }

            .background-overlay {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background-image: url('{{ asset('img/home-bg.jpg') }}');
                background-size: 80% auto; /* Adjust the size here */
                background-position: center;
                background-repeat: no-repeat;
                opacity: 0.5; /* Adjust the opacity here */
                z-index: -1;
            }

            .navbar-default {
                background-color: transparent;
                border: none;
            }
            .navbar-static-top {
                margin-bottom: 19px;
            }
            .navbar-default .navbar-nav>li>a {
                color: #fff;
                font-weight: 600;
                font-size: 15px;
            }
            .navbar-default .navbar-nav>li>a:hover{
                color: #ccc;
            }
            .navbar-default .navbar-brand {
                color: #ccc;
            }
        </style>
    </head>

    <body>
        <div class="background-overlay"></div>

        @include('layouts.partials.home_header')

        <div class="container">
            <div class="content">
                @section('content')
                    <h1>Welcome to Our Website</h1>
                    <p>This is the default home page content. You can edit this content by overriding the 'content' section in other views.</p>
                @show
            </div>
        </div>

        @include('layouts.partials.javascripts')

        <!-- Scripts -->
        <script src="{{ asset('js/login.js?v=' . $asset_v) }}"></script>
        @yield('javascript')
    </body>
</html>
