<!doctype html>
<html lang="<?php echo e(config('app.locale'), false); ?>">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- CSRF Token -->
        <meta name="csrf-token" content="<?php echo e(csrf_token(), false); ?>">

        <title><?php echo $__env->yieldContent('title', 'Home Page'); ?></title>

        <link rel="stylesheet" href="<?php echo e(asset('css/vendor.css'), false); ?>">

        <!-- Styles -->
        <style>
            body {
                min-height: 100vh;
                background-color: #243949;
                color: #fff;
                position: relative;
            }

            .background-overlay {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background-image: url('<?php echo e(asset('img/home-bg.jpg'), false); ?>');
                background-size: 80% auto; /* Adjust the size here */
                background-position: center;
                background-repeat: no-repeat;
                opacity: 0.5; /* Adjust the opacity here */
                z-index: -1;
            }

            .navbar-default {
                background-color: transparent;
                border: none;
            }
            .navbar-static-top {
                margin-bottom: 19px;
            }
            .navbar-default .navbar-nav>li>a {
                color: #fff;
                font-weight: 600;
                font-size: 15px;
            }
            .navbar-default .navbar-nav>li>a:hover{
                color: #ccc;
            }
            .navbar-default .navbar-brand {
                color: #ccc;
            }
        </style>
    </head>

    <body>
        <div class="background-overlay"></div>

        <?php echo $__env->make('layouts.partials.home_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="container">
            <div class="content">
                <?php $__env->startSection('content'); ?>
                    <h1>Welcome to Our Website</h1>
                    <p>This is the default home page content. You can edit this content by overriding the 'content' section in other views.</p>
                <?php echo $__env->yieldSection(); ?>
            </div>
        </div>

        <?php echo $__env->make('layouts.partials.javascripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Scripts -->
        <script src="<?php echo e(asset('js/login.js?v=' . $asset_v), false); ?>"></script>
        <?php echo $__env->yieldContent('javascript'); ?>
    </body>
</html>
<?php /**PATH /home/u627005231/domains/kaiapos.net/public_html/resources/views/layouts/home.blade.php ENDPATH**/ ?>